//#pragma LINK_INFO DERIVATIVE "mc9s12p128"

/******************************************************************************
													            Copyright (c) Freescale 2009
File Name    : $RCSfile: main.c,v $

Current Revision :	$Revision: 1.0 $

PURPOSE: main program entry.                       
                                                                          
                                                                       
DESCRIPTION:  function main() providing initial program entry.
              function Delay() - simple software delay
              function Wait1ms() - 1mS software delay
              function WaitNms() - N ms software delay
              function ConfigurePorts() - provides I/O set up
                                                         
                                                                          
UPDATE HISTORY                                                            
REV  AUTHOR    DATE        DESCRIPTION OF CHANGE                          
---  ------    --------    ---------------------                          
1.0  r28318    09/06/09    - initial coding

     *******************************************************************
     * File created by: Freescale East Kilbride MSG Applications Group *
     *******************************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

/************************* Include Files *************************************/
/*general includes */
#include <hidef.h>  /* also includes boolean definitions in stdtypes.h     */
#include <MC9S12P128.h>     /* derivative information */
#include "target.h" 
#include "S12P_peripherals.h" /* includes peripherals definitions and FSL data types */


/************************* typedefs ******************************************/

/************************* #defines ******************************************/

/************************* Constants *****************************************/
#pragma CONST_SEG DEFAULT

#define CONST (BUSCLK_FREQ_KHZ / 6 /* loop cycles */ )

/************************* Global Variables **********************************/
#pragma DATA_SEG DEFAULT

/************************* function prototypes *******************************/
#pragma CODE_SEG DEFAULT
/************************* Functions *****************************************/
#pragma CODE_SEG DEFAULT

/******************************************************************************
Function Name  : main
Engineer       : r28318	
Date           : 09/06/09
Parameters     : NONE
Returns        : NONE
Notes          : main routine called by Startup.c. 
******************************************************************************/


void main(void) {
   byte txbuffer;
   
      /* initialise the system clock - 32MHz Bus CLK, 4MHz Crystal */
	 CPMUCLKS_PLLSEL = 1; /*select the PLL as the clock source */
	 CPMUOSC = 0xC8;
   while(!CPMUFLG_UPOSC);	/* wait for OSC to stabilise */
   CPMUREFDIV = ((REFCLK_RANGE<<6) | (PLL_DIVIDER-1));       /* Reference Clock / 1 = 4MHz */
   CPMUSYNR = ((VCO_RANGE<<6) | (PLL_MULTIPLIER-1));         /* configure the PLL  x 16 = 64MHz VCO */
   CPMUPOSTDIV = (PLL_POSTDIVIDER-1);      /* Post divider / 1 = 32MHz Bus CLK */
   while(!CPMUFLG_LOCK)	/* wait for PLL to lock */
   {
   }

  	   /* initialise the IO */   
   PORTA = 0x00;	   
   DDRA = 0x0F;  /* LEDs enabled */
       /* Enable Port B */
   PUCR 	= 0xFE; /* Enable pull-ups on Port B */
   DDRB = 0x00;   /* Port B all inputs */
	 
      /* initialise the CAN */  
   CANCTL0 = 0x01;              /*	enter init mode */
   while(!(CANCTL1_INITAK));		/* wait for init mode */

   CANCTL1 = 0xA0;	/* enable CAN module, Loopback Mode, Ext OSC */
   CANBTR0 = 0xC3;	/* sync jump - 4 Tq clocks, prescalar = 3 */
   CANBTR1 = 0x3A;	/* Tseg = 3, Tseg1 = 10, 1 sample per bit */
   CANIDAC = 0x10;	/* four 16-bit filters */

   CANIDAR0 = 0x20;	/* Filter 0, ID=0x100 Standard Identifier */
   CANIDMR0 = 0x00;
   CANIDAR1 = 0x00;
   CANIDMR1 = 0x07; /* AM[2:0] = 7 to receive standard identifiers */

   CANIDAR2 = 0x00; /* Filter 1, ID=0x0000 */
   CANIDMR2 = 0x00;
   CANIDAR3 = 0x00;
   CANIDMR3 = 0x07; /* AM[2:0] = 7 to receive standard identifiers */

   CANIDAR4 = 0x00;	/* Filter 2, ID=0x0000 */
   CANIDMR4 = 0x00;
   CANIDAR5 = 0x00;
   CANIDMR5 = 0x07; /* AM[2:0] = 7 to receive standard identifiers */

   CANIDAR6 = 0x00;	/* Filter 3, ID=0x0000 */
   CANIDMR6 = 0x00;
   CANIDAR7 = 0x00;
   CANIDMR7 = 0x07; /* AM[2:0] = 7 to receive standard identifiers */

   CANCTL0 = 0x00;	/* exit init mode */
   while(CANCTL1_INITAK);			/* wait until module exits init mode */
     
   while(!(CANCTL0_SYNCH));		/* wait for CAN module to synch */
  
	 CANRFLG = 0xC3;					/* reset Rx flags */

  		   
   for(;;)
    {
     while (!CANTFLG);      /* Wait for empty Tx Buffer */
     CANTBSEL = CANTFLG;	 /* Select the empty Tx Buffer */
	   txbuffer = CANTBSEL;  /* Save the empty buffer */

     CANTXIDR0 = 0x20;    /* load message id value to ID regs */
     CANTXIDR1 = 0x00;
     CANTXIDR2 = 0x00;
     CANTXIDR3 = 0x00;

     CANTXDSR0 = PORTB;		/* load data to send */

     CANTXDLR = 0x01;			/* set data length */
     CANTXTBPR = 0x80;		/* set data buffer priority */

     CANTFLG = txbuffer;  /* start transmission */

     while(!(CANTFLG & txbuffer));	/* wait for Tx to complete */
     
		 if(CANRFLG_RXF)    /* has a message been received ? */
		  {
		    PORTA = CANRXDSR0; /* Display transmitted PORTB on LEDs */
        CANRFLG_RXF =1;    /* Clear RXF */
		  }

		}

}

/******************************************************************************
Function Name	:	Wait1ms
Engineer		:	
Date			:	02/06/00

Parameters		:	none
Returns			:	none
Notes			:	Waits 1mS. 
******************************************************************************/

void Wait1ms(void){
   asm {  
     LDX #CONST
     loop:
     DEX     ;1 cycles
     CPX #0  ;2 cycles
     BNE loop ;3 cycles              
   }     
}

/******************************************************************************
Function Name	:	WaitNms
Engineer		:	
Date			:	02/06/00

Parameters		:	int
Returns			:	none
Notes			:	Waits for N mS. 
******************************************************************************/

void WaitNms(int n){
   int i;
   for(i=1;i<=n;i++) Wait1ms();
}

/******************************************************************************
Function Name	:	Delay
Engineer		   :	r32151
Date			   :	02/06/00
Parameters		:	unsigned int delayTime
Returns			:	NONE
Notes			   :	Simple software delay dependent on CPU clock frequency and
					   compile strategy 
******************************************************************************/
void Delay(unsigned int delayTime)					
{
   unsigned int x;						 /*outer loop counter */
  	char y;									 /*inner loop counter */

  	for (x=0; x<delayTime; x++)
  	{	
  		for (y=0; y<100; y++)
  		{} 
	}
}

/******************************************************************************
Function Name	:	ConfigurePorts
Engineer		   :	r32151, updated b06320/r28318
Date			   :	01/03/05, updated 09/06/09
Headers			: 	target.h
Parameters		:	NONE
Returns			:	NONE
Notes			   :	Code to set up i/o ports 
******************************************************************************/
void ConfigurePorts(void)
{

/******* CORE PORTS ********/

/* core interrupts */
/* This register register was renamed. On early D, A and H families it is called INTCR,
   on all other families it is called IRQCR. */
	IRQCR = 0;		/* IRQ only responds to falling edge  */
								/*	- note IRQE is write once */								

/*include this line to clear the X-bit in order to enable the XIRQ function */   
//  asm ANDCC #~BIT6;	

/* drive level */
	RDRIV = ALL_REDUCED_DRIVE;						/* core ports reduced drive */
/* Enable Pull devices */
	PUCR 	= ALL_PULLS_ON; 							/* Note: only pull-ups available on core ports */
						  						/* some port E pins require care when using external pull devices*/
						  						/* port E.7: pull up for LC Pierce, tie low for ext osc or full Pierce, */
						  						/*           reset enables internal pull up.                     */
						  						/* port E.5 & E.6 should be pulled down for single chip use      */
						  						/*           reset enables internal pull down.                   */
/* configure port data and direction */
/* PORT A */
	PORTA = ALL_LOW;	   
//	DDRA = ALL_OUTPUTS;
  DDRA = 0x0F;
/* PORT B */
	PORTB = ALL_HIGH;	   					
	DDRB = ALL_OUTPUTS; 					    
/* PORT E */
	PORTE = ALL_LOW;	   
	DDRE = ALL_INPUTS; 		
/******* PIM PORTS ********/

/* PORT T */
/* Configure Pull-polarity */
	PPST 	= ALL_PULLED_DOWN;
/* Enable Pull devices */
	PERT 	= ALL_PULLS_ON;
/* drive level */
	RDRT 	= ALL_REDUCED_DRIVE;
/* port data */
	PTT 	= ALL_LOW;   
/* port direction */
	DDRT 	= ALL_INPUTS;

/* PORT S */
/* Configure Pull-polarity */
	PPSS 	= ALL_PULLED_DOWN;
/* Enable Pull devices */

/* Enable Pull devices */
	PERS 	= ALL_PULLS_ON;					
//	PERS.byte 	= BIT7|BIT6|BIT5|BIT4;					/* S12 EVB - no pull devices on port S0-3 due to avoid */ 
																	/* conflict with connections to RS232 transceiver */
/* drive level */
	RDRS 	= ALL_REDUCED_DRIVE;
/* Configure wired-or outputs */
	WOMS 	= 0x00;
/* port data */
	PTS 	= ALL_LOW;	   
/* port direction */
	DDRS 	= ALL_INPUTS;
	
/* PORT M */
/* Configure Pull-polarity */
	PPSM = ALL_PULLED_DOWN;
/* Enable Pull devices */
	PERM 	= ALL_PULLS_ON; 	
//	PERM.byte 	= BIT7|BIT6|BIT5|BIT4|BIT3|BIT2|BIT1; 	/* S12 EVB - no pull device enebled on port M0 as it's */
																  	   /*driven by the CAN transceiver Rx pin */
/* drive level */
	RDRM 	= ALL_REDUCED_DRIVE;
/* Configure wired-or outputs */
	WOMM 	= 0x00;	   
/* port data */
	PTM 	= ALL_LOW;	   
/* port direction */
	DDRM 	= ALL_INPUTS;
	
/* PORT P */
/* Configure Pull-polarity */
	PPSP 	= ALL_PULLED_UP;
/* Enable Pull devices */
	PERP 	= ALL_PULLS_ON;
/* drive level */
	RDRP 	= ALL_REDUCED_DRIVE;						
/* port data */
	PTP 	= ALL_LOW;		   
/* port direction */
	DDRP 	= ALL_INPUTS;     
/* Clear all interrupt flags */
	PIFP 	= 0xFF;
/* Enable interrupts */
//	PIEP 	= 0x00;
	PIEP 	= 0x03;
	

/* PORT J */
/* Configure Pull-polarity */
	PPSJ 	= ALL_PULLED_DOWN;
/* Enable Pull devices */
	PERJ 	= ALL_PULLS_ON;
/* drive level */
	RDRJ 	= ALL_REDUCED_DRIVE;
/* port data */
	PTJ 	= ALL_LOW;	   
/* port direction */
	DDRJ 	= BIT_7 | BIT_6 ;	 /* two debug outputs */
/* Clear all interrupt flags */
	PIFJ 	= 0xFF;
/* Enable interrupts */
	PIEJ 	= 0x00;
	


/******* ATD PORTS ********/
/* In order to use the digital input function the ATDIEN bit needs to be set */
/* ! NOTE: ATD port pull-ups are active for both digital and analog inputs ! */
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/	

/*for PAD[7:0] */	
   PER0AD 	= ALL_PULLS_OFF;     /* Port AD0 Pull-up Enable */
	 ATDDIEN  = 0x00;				/* 1 = digital input enabled */
   RDR1AD 	= ALL_REDUCED_DRIVE; /* Port AD0 Reduced Drive Register 1 */
   PT1AD 	  = ALL_LOW;	         /* Port AD0 I/O Register 1 */
   DDR1AD 	= ALL_INPUTS;        /* Port AD0 Data Direction Register 1 */

/*for PAD[15:8] */  
   PER1AD 	= ALL_PULLS_OFF;     /* Port AD1 Pull-up Enable */
	 ATDDIEN  = 0x00;				/* 1 = digital input enabled */
   RDR0AD 	= ALL_REDUCED_DRIVE; /* Port AD1 Reduced Drive Register 1 */
   PT0AD   	= ALL_LOW;	         /* Port AD1-1 I/O Register 1 */
   DDR0AD 	= ALL_INPUTS;        /* Port AD1 Data Direction Register 0 */	


 /***** ECKL options *****/
 
/* ECLK available on PortE.4, ECLKx2 available on Port E.7 
    - note, keeping port E configured for reduced drive 
		 will minimise ECLK generated noise */							
#ifdef ECLK_OUT
// ECLKDIV = 1 to 32; DEFINED IN TARGET.H 
/* select one: */
//   ECLKCTL = ECLKCTL_NCLKX2_MASK|ECLKCTL_NECLK_MASK;              /* ECLKx2 off. ECLK              off */
//   ECLKCTL = ECLKCTL_NECLK_MASK;                                  /* ECLKx2 on.  ECLK              off */
   ECLKCTL = (ECLKCTL_NCLKX2_MASK|(ECLKDIV-1));                     /* ECLKx2 off. ECLK/ECLKDIV       on */
//   ECLKCTL = ECLKCTL_NCLKX2_MASK|(ECLKDIV-1)|ECLKCTL_DIV16_MASK;  /* ECLKx2 off. ECLK/(ECLKDIV*16)  on */
//   ECLKCTL = (ECLKDIV-1);                                         /* ECLKx2 on.  ECLK/(ECLKDIV)     on */
//   ECLKCTL = (ECLKDIV-1)|ECLKCTL_DIV16_MASK;                      /* ECLKx2 on.  ECLK/(ECLKDIV*16)  on */


#endif
}



#pragma CODE_SEG DEFAULT